/*
Macro_Scripts File
Purposes:  
    
	define action for each creatable System object to hook up to the create main menu (or quads)
	defines macros for Quads

Revision History

	2 aug 2004, Pierre-Felix Breton
		added 3ds max r7 objects

	12 dec 2003, Pierre-Felix Breton, 
		added product switcher: this macro file can be shared with all Discreet products


	26 Mai 2003: Pierre-felix Breton
	created for 3ds MAX 6

*/

-- Macro Scripts for Objects
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK

-----------------------------------------------------------------------------------------
-- Day Light System
-----------------------------------------------------------------------------------------

macroScript DayLight 
category:~DAYLIGHT_CATEGORY~
internalCategory:"Lights and Cameras"
ButtonText:~DAYLIGHT_SYSTEM_BUTTONTEXT~
tooltip:~DAYLIGHT_SYSTEM_TOOLTIP~ 
icon:#("Systems",2)
(
	on execute do 
	 	(
			StartObjectCreation Daylight
		)
     on isChecked return mcrUtils.IsCreating Daylight
)


macroScript SunLight 
category:~LIGHTS_AND_CAMERAS_CATEGORY~
internalCategory:"Lights and Cameras"
ButtonText:~SUNLIGHT_SYSTEM_BUTTONTEXT~
tooltip:~SUNLIGHT_SYSTEM_TOOLTIP~ 
(
     on execute do 
	 	(
			StartObjectCreation Sunlight
		)
     on isChecked return mcrUtils.IsCreating Sunlight
)


-----------------------------------------------------------------------------------------
macroScript RingArray
            category:~OBJECTS_SYSTEMS_CATEGORY~ 
            internalCategory:"Objects Systems" 
            tooltip:~RING_ARRAY_TOOLTIP~ 
            buttontext:~RING_ARRAY_BUTTONTEXT~ 
            --Icon:#("SW_GeoDef",7)
(
    on execute do StartObjectCreation Ring_Array 
    on isChecked return mcrUtils.IsCreating Ring_Array
)

-----------------------------------------------------------------------------------------
macroScript Biped
            category:~BIPED_OBJECTS_SYSTEMS_CATEGORY~ 
            internalCategory:"Objects Systems" 
            tooltip:~BIPED_TOOLTIP~ 
            buttontext:~BIPED_BUTTONTEXT~ 
            --Icon:#("SW_GeoDef",7)
(
    on execute do StartObjectCreation bipedSystem
    on isChecked return mcrUtils.IsCreating bipedSystem
)


